

# ################################################
# (1) Constrained MLE
# ################################################

# {G-formula = {Y, M}, IPW = {M, A}, Mixed = {A, Y}, AIPW = {A, M, Y}}

optimize_nloptr <- function(dat, func, beta_start, px, fmla, opt){
 
 fmla_y = fmla$fmla_y
 fmla_l = fmla$fmla_l
 fmla_m = fmla$fmla_m
 fmla_a = fmla$fmla_a 
 
 tau_u = opt$tau_u
 tau_l = opt$tau_l
 estimator = opt$estimator
 
 # Prepare the data
 Xa = as.matrix(model.matrix(fmla_a, data=model.frame(dat, na.action = NULL))) 
 Xm = as.matrix(model.matrix(fmla_m, data=model.frame(dat, na.action = NULL)))
 Xl = as.matrix(model.matrix(fmla_l, data=model.frame(dat, na.action = NULL)))
 Xy = as.matrix(model.matrix(fmla_y, data=model.frame(dat, na.action = NULL)))
 A = dat$A
 M = dat$M
 L = dat$L
 Y = dat$Y
 
 # Initial values for beta
 if (length(beta_start) == 0){
  beta_start = rep(0.1, ncol(Xm) + ncol(Xl) + ncol(Xy))
  names(beta_start) = c(colnames(Xm), colnames(Xl), colnames(Xy))
 }
 
 # Define the negative log likelihood function
 eval_f <- function(beta, dat, Xa, Xm, Xl, Xy, A, M, L, Y, func, px, opt){
  n = length(Y)

  beta_m = beta[1:ncol(Xm)]
  beta_l = beta[(ncol(Xm)+1):(ncol(Xm)+ncol(Xl))]
  beta_y = beta[(ncol(Xm)+ncol(Xl)+1):length(beta)]
  names(beta_m) = colnames(Xm)
  names(beta_l) = colnames(Xl)
  names(beta_y) = colnames(Xy)
   
   Y_hat = Xy%*%beta_y
   p_Y = dnorm(Y, Y_hat, 1)
   
   p_L1 = 1/(1+exp(-Xl%*%beta_l))
   p_L = L*p_L1 + (1-L)*(1-p_L1)
   
   p_M1 = 1/(1+exp(-Xm%*%beta_m))
   p_M = M*p_M1 + (1-M)*(1-p_M1)
   
   
   log_lik = sum( log(p_M) + log(p_L) + log(p_Y))
  return(-log_lik/n)
 }
 
 # Define the inequlity constraint 
 eval_g_ineq <- function(beta, dat, Xa, Xm, Xl, Xy, A, M, L, Y, func, px, opt){

  tau_u = opt$tau_u
  tau_l = opt$tau_l
  
  beta_m = beta[1:ncol(Xm)]
  beta_l = beta[(ncol(Xm)+1):(ncol(Xm)+ncol(Xl))]
  beta_y = beta[(ncol(Xm)+ncol(Xl)+1):length(beta)]
  names(beta_m) = colnames(Xm)
  names(beta_l) = colnames(Xl)
  names(beta_y) = colnames(Xy)
  
  beta_par = list(beta_y=beta_y, beta_l=beta_l, beta_m=beta_m, beta_a=NULL)
  pse = func(dat, beta_par, px, opt)
 
  eval_g =  c(pse - tau_u, tau_l - pse)
  return(eval_g)
 }
 
 # Solve the optimization problem
 mle_res = nloptr(x0=beta_start, 
              eval_f=eval_f, 
              eval_g_ineq=eval_g_ineq,
              opts = list("algorithm"="NLOPT_LN_COBYLA","xtol_rel"=1.0e-8, "maxeval"=5000), 
              dat=dat, Xa=Xa, Xm=Xm, Xl=Xl, Xy=Xy, A=A, M=M, L=L, Y=Y, 
              func=func, px=px, opt=opt)

 
 # Returnt the parameters
 beta = mle_res$solution
  
 beta_m = beta[1:ncol(Xm)]
 beta_l = beta[(ncol(Xm)+1):(ncol(Xm)+ncol(Xl))]
 beta_y = beta[(ncol(Xm)+ncol(Xl)+1):length(beta)]
 names(beta_m) = colnames(Xm)
 names(beta_l) = colnames(Xl)
 names(beta_y) = colnames(Xy)
 
 return(list(beta_m=beta_m, 
             beta_l=beta_l,
             beta_y=beta_y))
}



